#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# script to convert old .mat calibration files in normal text files

import numpy as np
import matplotlib.pyplot as plt
from scipy.io import loadmat

cal_dict = {
        "Maya red" : 'SpecResp_MayaPro_200umRedFiber_WavelengthCorrected_Updated_16052014',
        "Maya steel" : 'SpecResp_MayaPro_50umSteelFiber_WavelengthCorrected_Updated_16052014',
    }

cal_red = loadmat(cal_dict.get("Maya red"))['cal'][:][0].T
cal_steel = loadmat(cal_dict.get("Maya steel"))['cal'][:][0].T

# Corresponding WL

cal_wl = np.array([ 200.786,  201.249,  201.712,  202.176,  202.639,  203.102,
        203.565,  204.028,  204.491,  204.954,  205.416,  205.879,
        206.342,  206.805,  207.268,  207.731,  208.193,  208.656,
        209.119,  209.582,  210.044,  210.507,  210.97 ,  211.432,
        211.895,  212.357,  212.82 ,  213.282,  213.745,  214.207,
        214.67 ,  215.132,  215.594,  216.057,  216.519,  216.981,
        217.444,  217.906,  218.368,  218.83 ,  219.292,  219.755,
        220.217,  220.679,  221.141,  221.603,  222.065,  222.527,
        222.989,  223.451,  223.913,  224.375,  224.837,  225.299,
        225.76 ,  226.222,  226.684,  227.146,  227.607,  228.069,
        228.531,  228.992,  229.454,  229.916,  230.377,  230.839,
        231.3  ,  231.762,  232.223,  232.685,  233.146,  233.608,
        234.069,  234.53 ,  234.992,  235.453,  235.914,  236.376,
        236.837,  237.298,  237.759,  238.22 ,  238.681,  239.143,
        239.604,  240.065,  240.526,  240.987,  241.448,  241.909,
        242.37 ,  242.831,  243.291,  243.752,  244.213,  244.674,
        245.135,  245.595,  246.056,  246.517,  246.978,  247.438,
        247.899,  248.359,  248.82 ,  249.281,  249.741,  250.202,
        250.662,  251.123,  251.583,  252.043,  252.504,  252.964,
        253.425,  253.885,  254.345,  254.805,  255.266,  255.726,
        256.186,  256.646,  257.106,  257.566,  258.026,  258.487,
        258.947,  259.407,  259.867,  260.327,  260.786,  261.246,
        261.706,  262.166,  262.626,  263.086,  263.546,  264.005,
        264.465,  264.925,  265.384,  265.844,  266.304,  266.763,
        267.223,  267.682,  268.142,  268.602,  269.061,  269.52 ,
        269.98 ,  270.439,  270.899,  271.358,  271.817,  272.277,
        272.736,  273.195,  273.654,  274.114,  274.573,  275.032,
        275.491,  275.95 ,  276.409,  276.868,  277.327,  277.786,
        278.245,  278.704,  279.163,  279.622,  280.081,  280.54 ,
        280.999,  281.458,  281.916,  282.375,  282.834,  283.292,
        283.751,  284.21 ,  284.668,  285.127,  285.586,  286.044,
        286.503,  286.961,  287.42 ,  287.878,  288.337,  288.795,
        289.253,  289.712,  290.17 ,  290.628,  291.087,  291.545,
        292.003,  292.461,  292.919,  293.378,  293.836,  294.294,
        294.752,  295.21 ,  295.668,  296.126,  296.584,  297.042,
        297.5  ,  297.958,  298.415,  298.873,  299.331,  299.789,
        300.247,  300.704,  301.162,  301.62 ,  302.077,  302.535,
        302.993,  303.45 ,  303.908,  304.365,  304.823,  305.28 ,
        305.738,  306.195,  306.653,  307.11 ,  307.567,  308.025,
        308.482,  308.939,  309.397,  309.854,  310.311,  310.768,
        311.225,  311.683,  312.14 ,  312.597,  313.054,  313.511,
        313.968,  314.425,  314.882,  315.339,  315.796,  316.252,
        316.709,  317.166,  317.623,  318.08 ,  318.536,  318.993,
        319.45 ,  319.906,  320.363,  320.82 ,  321.276,  321.733,
        322.189,  322.646,  323.102,  323.559,  324.015,  324.472,
        324.928,  325.385,  325.841,  326.297,  326.753,  327.21 ,
        327.666,  328.122,  328.578,  329.035,  329.491,  329.947,
        330.403,  330.859,  331.315,  331.771,  332.227,  332.683,
        333.139,  333.595,  334.051,  334.506,  334.962,  335.418,
        335.874,  336.33 ,  336.785,  337.241,  337.697,  338.152,
        338.608,  339.064,  339.519,  339.975,  340.43 ,  340.886,
        341.341,  341.797,  342.252,  342.707,  343.163,  343.618,
        344.073,  344.529,  344.984,  345.439,  345.894,  346.35 ,
        346.805,  347.26 ,  347.715,  348.17 ,  348.625,  349.08 ,
        349.535,  349.99 ,  350.445,  350.9  ,  351.355,  351.81 ,
        352.265,  352.719,  353.174,  353.629,  354.084,  354.538,
        354.993,  355.448,  355.902,  356.357,  356.812,  357.266,
        357.721,  358.175,  358.63 ,  359.084,  359.539,  359.993,
        360.447,  360.902,  361.356,  361.81 ,  362.265,  362.719,
        363.173,  363.627,  364.082,  364.536,  364.99 ,  365.444,
        365.898,  366.352,  366.806,  367.26 ,  367.714,  368.168,
        368.622,  369.076,  369.53 ,  369.984,  370.437,  370.891,
        371.345,  371.799,  372.252,  372.706,  373.16 ,  373.613,
        374.067,  374.521,  374.974,  375.428,  375.881,  376.335,
        376.788,  377.241,  377.695,  378.148,  378.602,  379.055,
        379.508,  379.961,  380.415,  380.868,  381.321,  381.774,
        382.227,  382.681,  383.134,  383.587,  384.04 ,  384.493,
        384.946,  385.399,  385.852,  386.304,  386.757,  387.21 ,
        387.663,  388.116,  388.569,  389.021,  389.474,  389.927,
        390.379,  390.832,  391.285,  391.737,  392.19 ,  392.642,
        393.095,  393.547,  394.   ,  394.452,  394.905,  395.357,
        395.809,  396.262,  396.714,  397.166,  397.619,  398.071,
        398.523,  398.975,  399.427,  399.879,  400.332,  400.784,
        401.236,  401.688,  402.14 ,  402.592,  403.044,  403.495,
        403.947,  404.399,  404.851,  405.303,  405.755,  406.206,
        406.658,  407.11 ,  407.562,  408.013,  408.465,  408.916,
        409.368,  409.819,  410.271,  410.722,  411.174,  411.625,
        412.077,  412.528,  412.98 ,  413.431,  413.882,  414.333,
        414.785,  415.236,  415.687,  416.138,  416.589,  417.041,
        417.492,  417.943,  418.394,  418.845,  419.296,  419.747,
        420.198,  420.649,  421.1  ,  421.55 ,  422.001,  422.452,
        422.903,  423.354,  423.804,  424.255,  424.706,  425.156,
        425.607,  426.058,  426.508,  426.959,  427.409,  427.86 ,
        428.31 ,  428.761,  429.211,  429.661,  430.112,  430.562,
        431.012,  431.463,  431.913,  432.363,  432.813,  433.263,
        433.714,  434.164,  434.614,  435.064,  435.514,  435.964,
        436.414,  436.864,  437.314,  437.764,  438.214,  438.664,
        439.113,  439.563,  440.013,  440.463,  440.912,  441.362,
        441.812,  442.261,  442.711,  443.161,  443.61 ,  444.06 ,
        444.509,  444.959,  445.408,  445.858,  446.307,  446.756,
        447.206,  447.655,  448.104,  448.554,  449.003,  449.452,
        449.901,  450.35 ,  450.8  ,  451.249,  451.698,  452.147,
        452.596,  453.045,  453.494,  453.943,  454.392,  454.841,
        455.29 ,  455.738,  456.187,  456.636,  457.085,  457.533,
        457.982,  458.431,  458.88 ,  459.328,  459.777,  460.225,
        460.674,  461.122,  461.571,  462.019,  462.468,  462.916,
        463.365,  463.813,  464.261,  464.71 ,  465.158,  465.606,
        466.054,  466.503,  466.951,  467.399,  467.847,  468.295,
        468.743,  469.191,  469.639,  470.087,  470.535,  470.983,
        471.431,  471.879,  472.327,  472.775,  473.223,  473.67 ,
        474.118,  474.566,  475.014,  475.461,  475.909,  476.356,
        476.804,  477.252,  477.699,  478.147,  478.594,  479.042,
        479.489,  479.936,  480.384,  480.831,  481.279,  481.726,
        482.173,  482.62 ,  483.068,  483.515,  483.962,  484.409,
        484.856,  485.303,  485.75 ,  486.197,  486.644,  487.091,
        487.538,  487.985,  488.432,  488.879,  489.326,  489.773,
        490.219,  490.666,  491.113,  491.56 ,  492.006,  492.453,
        492.899,  493.346,  493.793,  494.239,  494.686,  495.132,
        495.579,  496.025,  496.472,  496.918,  497.364,  497.811,
        498.257,  498.703,  499.149,  499.596,  500.042,  500.488,
        500.934,  501.38 ,  501.826,  502.272,  502.718,  503.164,
        503.61 ,  504.056,  504.502,  504.948,  505.394,  505.84 ,
        506.286,  506.731,  507.177,  507.623,  508.069,  508.514,
        508.96 ,  509.406,  509.851,  510.297,  510.742,  511.188,
        511.633,  512.079,  512.524,  512.97 ,  513.415,  513.86 ,
        514.306,  514.751,  515.196,  515.642,  516.087,  516.532,
        516.977,  517.422,  517.867,  518.312,  518.758,  519.203,
        519.648,  520.093,  520.537,  520.982,  521.427,  521.872,
        522.317,  522.762,  523.207,  523.651,  524.096,  524.541,
        524.985,  525.43 ,  525.875,  526.319,  526.764,  527.208,
        527.653,  528.097,  528.542,  528.986,  529.431,  529.875,
        530.319,  530.764,  531.208,  531.652,  532.097,  532.541,
        532.985,  533.429,  533.873,  534.317,  534.761,  535.205,
        535.649,  536.093,  536.537,  536.981,  537.425,  537.869,
        538.313,  538.757,  539.201,  539.644,  540.088,  540.532,
        540.976,  541.419,  541.863,  542.307,  542.75 ,  543.194,
        543.637,  544.081,  544.524,  544.968,  545.411,  545.854,
        546.298,  546.741,  547.184,  547.628,  548.071,  548.514,
        548.957,  549.401,  549.844,  550.287,  550.73 ,  551.173,
        551.616,  552.059,  552.502,  552.945,  553.388,  553.831,
        554.274,  554.717,  555.159,  555.602,  556.045,  556.488,
        556.93 ,  557.373,  557.816,  558.258,  558.701,  559.144,
        559.586,  560.029,  560.471,  560.914,  561.356,  561.798,
        562.241,  562.683,  563.125,  563.568,  564.01 ,  564.452,
        564.894,  565.337,  565.779,  566.221,  566.663,  567.105,
        567.547,  567.989,  568.431,  568.873,  569.315,  569.757,
        570.199,  570.641,  571.083,  571.524,  571.966,  572.408,
        572.85 ,  573.291,  573.733,  574.175,  574.616,  575.058,
        575.499,  575.941,  576.382,  576.824,  577.265,  577.707,
        578.148,  578.589,  579.031,  579.472,  579.913,  580.355,
        580.796,  581.237,  581.678,  582.119,  582.56 ,  583.002,
        583.443,  583.884,  584.325,  584.766,  585.207,  585.647,
        586.088,  586.529,  586.97 ,  587.411,  587.852,  588.292,
        588.733,  589.174,  589.614,  590.055,  590.496,  590.936,
        591.377,  591.817,  592.258,  592.698,  593.139,  593.579,
        594.02 ,  594.46 ,  594.9  ,  595.341,  595.781,  596.221,
        596.661,  597.102,  597.542,  597.982,  598.422,  598.862,
        599.302,  599.742,  600.182,  600.622,  601.062,  601.502,
        601.942,  602.382,  602.822,  603.261,  603.701,  604.141,
        604.581,  605.02 ,  605.46 ,  605.9  ,  606.339,  606.779,
        607.218,  607.658,  608.097,  608.537,  608.976,  609.416,
        609.855,  610.294,  610.734,  611.173,  611.612,  612.052,
        612.491,  612.93 ,  613.369,  613.808,  614.247,  614.687,
        615.126,  615.565,  616.004,  616.443,  616.882,  617.32 ,
        617.759,  618.198,  618.637,  619.076,  619.515,  619.953,
        620.392,  620.831,  621.269,  621.708,  622.147,  622.585,
        623.024,  623.462,  623.901,  624.339,  624.778,  625.216,
        625.655,  626.093,  626.531,  626.969,  627.408,  627.846,
        628.284,  628.722,  629.161,  629.599,  630.037,  630.475,
        630.913,  631.351,  631.789,  632.227,  632.665,  633.103,
        633.541,  633.978,  634.416,  634.854,  635.292,  635.73 ,
        636.167,  636.605,  637.043,  637.48 ,  637.918,  638.355,
        638.793,  639.23 ,  639.668,  640.105,  640.543,  640.98 ,
        641.418,  641.855,  642.292,  642.73 ,  643.167,  643.604,
        644.041,  644.478,  644.916,  645.353,  645.79 ,  646.227,
        646.664,  647.101,  647.538,  647.975,  648.412,  648.849,
        649.285,  649.722,  650.159,  650.596,  651.033,  651.469,
        651.906,  652.343,  652.779,  653.216,  653.652,  654.089,
        654.526,  654.962,  655.399,  655.835,  656.271,  656.708,
        657.144,  657.58 ,  658.017,  658.453,  658.889,  659.325,
        659.762,  660.198,  660.634,  661.07 ,  661.506,  661.942,
        662.378,  662.814,  663.25 ,  663.686,  664.122,  664.558,
        664.994,  665.429,  665.865,  666.301,  666.737,  667.172,
        667.608,  668.044,  668.479,  668.915,  669.351,  669.786,
        670.222,  670.657,  671.093,  671.528,  671.963,  672.399,
        672.834,  673.269,  673.705,  674.14 ,  674.575,  675.01 ,
        675.445,  675.881,  676.316,  676.751,  677.186,  677.621,
        678.056,  678.491,  678.926,  679.361,  679.796,  680.23 ,
        680.665,  681.1  ,  681.535,  681.969,  682.404,  682.839,
        683.274,  683.708,  684.143,  684.577,  685.012,  685.446,
        685.881,  686.315,  686.75 ,  687.184,  687.618,  688.053,
        688.487,  688.921,  689.356,  689.79 ,  690.224,  690.658,
        691.092,  691.526,  691.961,  692.395,  692.829,  693.263,
        693.697,  694.131,  694.564,  694.998,  695.432,  695.866,
        696.3  ,  696.734,  697.167,  697.601,  698.035,  698.468,
        698.902,  699.336,  699.769,  700.203,  700.636,  701.07 ,
        701.503,  701.937,  702.37 ,  702.803,  703.237,  703.67 ,
        704.103,  704.536,  704.97 ,  705.403,  705.836,  706.269,
        706.702,  707.135,  707.568,  708.001,  708.434,  708.867,
        709.3  ,  709.733,  710.166,  710.599,  711.032,  711.465,
        711.897,  712.33 ,  712.763,  713.195,  713.628,  714.061,
        714.493,  714.926,  715.358,  715.791,  716.223,  716.656,
        717.088,  717.521,  717.953,  718.385,  718.818,  719.25 ,
        719.682,  720.114,  720.547,  720.979,  721.411,  721.843,
        722.275,  722.707,  723.139,  723.571,  724.003,  724.435,
        724.867,  725.299,  725.731,  726.162,  726.594,  727.026,
        727.458,  727.889,  728.321,  728.753,  729.184,  729.616,
        730.047,  730.479,  730.91 ,  731.342,  731.773,  732.205,
        732.636,  733.067,  733.499,  733.93 ,  734.361,  734.793,
        735.224,  735.655,  736.086,  736.517,  736.948,  737.379,
        737.81 ,  738.241,  738.672,  739.103,  739.534,  739.965,
        740.396,  740.827,  741.258,  741.688,  742.119,  742.55 ,
        742.98 ,  743.411,  743.842,  744.272,  744.703,  745.133,
        745.564,  745.994,  746.425,  746.855,  747.286,  747.716,
        748.146,  748.577,  749.007,  749.437,  749.867,  750.298,
        750.728,  751.158,  751.588,  752.018,  752.448,  752.878,
        753.308,  753.738,  754.168,  754.598,  755.028,  755.458,
        755.887,  756.317,  756.747,  757.177,  757.606,  758.036,
        758.466,  758.895,  759.325,  759.754,  760.184,  760.613,
        761.043,  761.472,  761.902,  762.331,  762.76 ,  763.19 ,
        763.619,  764.048,  764.478,  764.907,  765.336,  765.765,
        766.194,  766.623,  767.052,  767.481,  767.91 ,  768.339,
        768.768,  769.197,  769.626,  770.055,  770.484,  770.912,
        771.341,  771.77 ,  772.199,  772.627,  773.056,  773.485,
        773.913,  774.342,  774.77 ,  775.199,  775.627,  776.056,
        776.484,  776.912,  777.341,  777.769,  778.197,  778.626,
        779.054,  779.482,  779.91 ,  780.338,  780.767,  781.195,
        781.623,  782.051,  782.479,  782.907,  783.335,  783.763,
        784.19 ,  784.618,  785.046,  785.474,  785.902,  786.329,
        786.757,  787.185,  787.612,  788.04 ,  788.468,  788.895,
        789.323,  789.75 ,  790.178,  790.605,  791.033,  791.46 ,
        791.887,  792.315,  792.742,  793.169,  793.596,  794.024,
        794.451,  794.878,  795.305,  795.732,  796.159,  796.586,
        797.013,  797.44 ,  797.867,  798.294,  798.721,  799.148,
        799.575,  800.001,  800.428,  800.855,  801.282,  801.708,
        802.135,  802.562,  802.988,  803.415,  803.841,  804.268,
        804.694,  805.121,  805.547,  805.973,  806.4  ,  806.826,
        807.252,  807.679,  808.105,  808.531,  808.957,  809.383,
        809.81 ,  810.236,  810.662,  811.088,  811.514,  811.94 ,
        812.366,  812.792,  813.217,  813.643,  814.069,  814.495,
        814.921,  815.346,  815.772,  816.198,  816.623,  817.049,
        817.475,  817.9  ,  818.326,  818.751,  819.177,  819.602,
        820.027,  820.453,  820.878,  821.303,  821.729,  822.154,
        822.579,  823.004,  823.43 ,  823.855,  824.28 ,  824.705,
        825.13 ,  825.555,  825.98 ,  826.405,  826.83 ,  827.255,
        827.68 ,  828.104,  828.529,  828.954,  829.379,  829.803,
        830.228,  830.653,  831.077,  831.502,  831.927,  832.351,
        832.776,  833.2  ,  833.625,  834.049,  834.473,  834.898,
        835.322,  835.746,  836.171,  836.595,  837.019,  837.443,
        837.868,  838.292,  838.716,  839.14 ,  839.564,  839.988,
        840.412,  840.836,  841.26 ,  841.684,  842.107,  842.531,
        842.955,  843.379,  843.803,  844.226,  844.65 ,  845.074,
        845.497,  845.921,  846.344,  846.768,  847.191,  847.615,
        848.038,  848.462,  848.885,  849.308,  849.732,  850.155,
        850.578,  851.001,  851.425,  851.848,  852.271,  852.694,
        853.117,  853.54 ,  853.963,  854.386,  854.809,  855.232,
        855.655,  856.078,  856.501,  856.924,  857.346,  857.769,
        858.192,  858.614,  859.037,  859.46 ,  859.882,  860.305,
        860.727,  861.15 ,  861.572,  861.995,  862.417,  862.84 ,
        863.262,  863.684,  864.107,  864.529,  864.951,  865.373,
        865.796,  866.218,  866.64 ,  867.062,  867.484,  867.906,
        868.328,  868.75 ,  869.172,  869.594,  870.016,  870.438,
        870.859,  871.281,  871.703,  872.125,  872.546,  872.968,
        873.39 ,  873.811,  874.233,  874.654,  875.076,  875.497,
        875.919,  876.34 ,  876.762,  877.183,  877.604,  878.026,
        878.447,  878.868,  879.289,  879.711,  880.132,  880.553,
        880.974,  881.395,  881.816,  882.237,  882.658,  883.079,
        883.5  ,  883.921,  884.342,  884.762,  885.183,  885.604,
        886.025,  886.445,  886.866,  887.287,  887.707,  888.128,
        888.549,  888.969,  889.39 ,  889.81 ,  890.23 ,  890.651,
        891.071,  891.492,  891.912,  892.332,  892.752,  893.173,
        893.593,  894.013,  894.433,  894.853,  895.273,  895.693,
        896.113,  896.533,  896.953,  897.373,  897.793,  898.213,
        898.633,  899.052,  899.472,  899.892,  900.312,  900.731,
        901.151,  901.571,  901.99 ,  902.41 ,  902.829,  903.249,
        903.668,  904.088,  904.507,  904.926,  905.346,  905.765,
        906.184,  906.604,  907.023,  907.442,  907.861,  908.28 ,
        908.699,  909.118,  909.537,  909.956,  910.375,  910.794,
        911.213,  911.632,  912.051,  912.47 ,  912.889,  913.307,
        913.726,  914.145,  914.563,  914.982,  915.401,  915.819,
        916.238,  916.656,  917.075,  917.493,  917.912,  918.33 ,
        918.748,  919.167,  919.585,  920.003,  920.422,  920.84 ,
        921.258,  921.676,  922.094,  922.512,  922.93 ,  923.348,
        923.766,  924.184,  924.602,  925.02 ,  925.438,  925.856,
        926.274,  926.692,  927.109,  927.527,  927.945,  928.362,
        928.78 ,  929.198,  929.615,  930.033,  930.45 ,  930.868,
        931.285,  931.703,  932.12 ,  932.537,  932.955,  933.372,
        933.789,  934.206,  934.624,  935.041,  935.458,  935.875,
        936.292,  936.709,  937.126,  937.543,  937.96 ,  938.377,
        938.794,  939.211,  939.628,  940.044,  940.461,  940.878,
        941.295,  941.711,  942.128,  942.545,  942.961,  943.378,
        943.794,  944.211,  944.627,  945.044,  945.46 ,  945.876,
        946.293,  946.709,  947.125,  947.542,  947.958,  948.374,
        948.79 ,  949.206,  949.622,  950.038,  950.454,  950.87 ,
        951.286,  951.702,  952.118,  952.534,  952.95 ,  953.366,
        953.782,  954.197,  954.613,  955.029,  955.444,  955.86 ,
        956.276,  956.691,  957.107,  957.522,  957.938,  958.353,
        958.769,  959.184,  959.599,  960.015,  960.43 ,  960.845,
        961.261,  961.676,  962.091,  962.506,  962.921,  963.336,
        963.751,  964.166,  964.581,  964.996,  965.411,  965.826,
        966.241,  966.656,  967.071,  967.485,  967.9  ,  968.315,
        968.729,  969.144,  969.559,  969.973,  970.388,  970.802,
        971.217,  971.631,  972.046,  972.46 ,  972.874,  973.289,
        973.703,  974.117,  974.532,  974.946,  975.36 ,  975.774,
        976.188,  976.602,  977.016,  977.43 ,  977.844,  978.258,
        978.672,  979.086,  979.5  ,  979.914,  980.328,  980.742,
        981.155,  981.569,  981.983,  982.396,  982.81 ,  983.224,
        983.637,  984.051,  984.464,  984.878,  985.291,  985.704,
        986.118,  986.531,  986.944,  987.358,  987.771,  988.184,
        988.597,  989.011,  989.424,  989.837,  990.25 ,  990.663,
        991.076,  991.489,  991.902,  992.315,  992.728,  993.14 ,
        993.553,  993.966,  994.379,  994.791,  995.204,  995.617,
        996.029,  996.442,  996.855,  997.267,  997.68 ,  998.092,
        998.504,  998.917,  999.329,  999.742, 1000.154, 1000.566,
       1000.978, 1001.391, 1001.803, 1002.215, 1002.627, 1003.039,
       1003.451, 1003.863, 1004.275, 1004.687, 1005.099, 1005.511,
       1005.923, 1006.335, 1006.747, 1007.158, 1007.57 , 1007.982,
       1008.394, 1008.805, 1009.217, 1009.628, 1010.04 , 1010.452,
       1010.863, 1011.275, 1011.686, 1012.097, 1012.509, 1012.92 ,
       1013.331, 1013.743, 1014.154, 1014.565, 1014.976, 1015.387,
       1015.799, 1016.21 , 1016.621, 1017.032, 1017.443, 1017.854,
       1018.265, 1018.676, 1019.086, 1019.497, 1019.908, 1020.319,
       1020.73 , 1021.14 , 1021.551, 1021.962, 1022.372, 1022.783,
       1023.193, 1023.604, 1024.014, 1024.425, 1024.835, 1025.246,
       1025.656, 1026.066, 1026.477, 1026.887, 1027.297, 1027.708,
       1028.118, 1028.528, 1028.938, 1029.348, 1029.758, 1030.168,
       1030.578, 1030.988, 1031.398, 1031.808, 1032.218, 1032.628,
       1033.037, 1033.447, 1033.857, 1034.267, 1034.676, 1035.086,
       1035.496, 1035.905, 1036.315, 1036.724, 1037.134, 1037.543,
       1037.953, 1038.362, 1038.771, 1039.181, 1039.59 , 1039.999,
       1040.408, 1040.818, 1041.227, 1041.636, 1042.045, 1042.454,
       1042.863, 1043.272, 1043.681, 1044.09 , 1044.499, 1044.908,
       1045.317, 1045.726, 1046.134, 1046.543, 1046.952, 1047.361,
       1047.769, 1048.178, 1048.587, 1048.995, 1049.404, 1049.812,
       1050.221, 1050.629, 1051.037, 1051.446, 1051.854, 1052.263,
       1052.671, 1053.079, 1053.487, 1053.895, 1054.304, 1054.712,
       1055.12 , 1055.528, 1055.936, 1056.344, 1056.752, 1057.16 ,
       1057.568, 1057.976, 1058.383, 1058.791, 1059.199, 1059.607,
       1060.015, 1060.422, 1060.83 , 1061.237, 1061.645, 1062.053,
       1062.46 , 1062.868, 1063.275, 1063.683, 1064.09 , 1064.497,
       1064.905, 1065.312, 1065.719, 1066.126, 1066.534, 1066.941,
       1067.348, 1067.755, 1068.162, 1068.569, 1068.976, 1069.383,
       1069.79 , 1070.197, 1070.604, 1071.011, 1071.418, 1071.824,
       1072.231, 1072.638, 1073.045, 1073.451, 1073.858, 1074.264,
       1074.671, 1075.078, 1075.484, 1075.891, 1076.297, 1076.703,
       1077.11 , 1077.516, 1077.922, 1078.329, 1078.735, 1079.141,
       1079.547, 1079.954, 1080.36 , 1080.766, 1081.172, 1081.578,
       1081.984, 1082.39 , 1082.796, 1083.202, 1083.607, 1084.013,
       1084.419, 1084.825, 1085.231, 1085.636, 1086.042, 1086.448,
       1086.853, 1087.259, 1087.664, 1088.07 , 1088.475, 1088.881,
       1089.286, 1089.692, 1090.097, 1090.502, 1090.908, 1091.313,
       1091.718, 1092.123, 1092.528, 1092.934, 1093.339, 1093.744,
       1094.149, 1094.554, 1094.959, 1095.364, 1095.769, 1096.173,
       1096.578, 1096.983, 1097.388, 1097.793, 1098.197, 1098.602,
       1099.007, 1099.411, 1099.816, 1100.22 ])


plt.plot(cal_wl, cal_red, label = 'Red')
plt.plot(cal_wl, cal_steel, label = 'Steel')
plt.ylim([0, 3])
plt.show(block=1)

# save new files
np.savetxt('Maya_pro_red200um_16052014.txt', np.c_[cal_wl, cal_red], delimiter='\t')
np.savetxt('Maya_pro_steel50um_16052014.txt', np.c_[cal_wl, cal_steel], delimiter='\t')